/*:
 * @target MZ
 * @plugindesc v1.5.2 既読スキップ（未読停止）/ Ctrl・L・右クリック / 既読色 / ネスト耐性 / 行位置キー & NewGameで既読クリア + オプションON/OFF（多言語表示）
 * @author Human Simulate Tools
 *
 * @param ReadSkipSwitchId
 * @text 有効化スイッチID
 * @type switch
 * @default 1
 *
 * @param AutoAdvanceRead
 * @text 既読は自動送り
 * @type boolean
 * @default true
 *
 * @param EnableCtrlKey
 * @text Ctrlキーでスキップ
 * @type boolean
 * @default true
 *
 * @param EnableLKey
 * @text Lキーでスキップ
 * @type boolean
 * @default true
 *
 * @param EnableRightClick
 * @text 右クリックでスキップ
 * @type boolean
 * @default true
 *
 * @param ReadTextColorIndex
 * @text 既読テキストの色(\C[n]) / -1で無効
 * @type number
 * @min -1
 * @max 31
 * @default 4
 *
 * @param IncludeMapEventInHash
 * @text 既読キーにマップ/イベントID
 * @type boolean
 * @default true
 *
 * @param IncludeCommonEventInHash
 * @text 既読キーにコモンイベントID
 * @type boolean
 * @default true
 *
 * @param IncludeFaceInHash
 * @text 既読キーに顔グラ情報
 * @type boolean
 * @default true
 *
 * @param IncludeCommandIndexInHash
 * @text 既読キーにイベント内の行位置(index)を含める
 * @type boolean
 * @default true
 * @desc 同じ文章がシーン内に複数ある時も別物として扱えるようにします（推奨ON）
 *
 * @param LanguageVarId
 * @text 既読キー用：言語変数ID（任意）
 * @type variable
 * @default 0
 *
 * @param MinCharsForRead
 * @text 既読対象の最小文字数（記号等除外後）
 * @type number
 * @min 0
 * @default 4
 *
 * @param IgnoreRegexForRead
 * @text 既読判定しない正規表現
 * @type string
 * @default ^[\\.・…。、．，,!！?？\\s　]+$
 *
 * @param ClearHistoryOnNewGame
 * @text NewGameで既読履歴をクリア
 * @type boolean
 * @default true
 *
 * @command ClearHistory
 * @text 既読履歴を全消去
 *
 * @-------------------------
 * @section Options Menu
 * @-------------------------
 *
 * @param ShowInOptions
 * @text オプションに項目を追加
 * @type boolean
 * @default true
 * @desc オプションに「既読スキップ（ON/OFF）」を表示します。
 *
 * @param OptionDefault
 * @text オプション初期値
 * @type boolean
 * @default false
 * @desc 初回起動時の既定値（Configの既定）。ロード/新規開始時にスイッチへ同期されます。
 *
 * @param OptionLabelVarId
 * @text 項目名 ラベル用 変数ID
 * @type variable
 * @default 0
 * @desc (任意) ここに文字列を入れるとそれが項目名になります（ゲーム中のみ）。空なら言語別フォールバックを使用。
 *
 * @param OptionFb0
 * @text 項目名(0:日本語)
 * @default 既読スキップ
 *
 * @param OptionFb1
 * @text 項目名(1:English)
 * @default Skip Read Text
 *
 * @param OptionFb2
 * @text 項目名(2:简体中文)
 * @default 已读跳过
 *
 * @param OptionFb3
 * @text 項目名(3:한국어)
 * @default 읽은 텍스트 스킵
 */
(() => {
  "use strict";
  const PN = "HS_ReadSkipMZ";
  const P  = PluginManager.parameters(PN);

  // ---- 既存パラメータ
  const SWITCH_ID   = Number(P["ReadSkipSwitchId"] || 1);
  const AUTO_ADV    = P["AutoAdvanceRead"] === "true";
  const KEY_CTRL    = P["EnableCtrlKey"] !== "false";
  const KEY_L       = P["EnableLKey"] !== "false";
  const KEY_RCLICK  = P["EnableRightClick"] !== "false";
  const READ_COLOR  = Number(P["ReadTextColorIndex"] || 4);

  const INCLUDE_ME  = P["IncludeMapEventInHash"] !== "false";
  const INCLUDE_CE  = P["IncludeCommonEventInHash"] !== "false";
  const INCLUDE_FACE= P["IncludeFaceInHash"] !== "false";
  const INCLUDE_IDX = P["IncludeCommandIndexInHash"] !== "false";
  const LANG_VAR    = Number(P["LanguageVarId"] || 0);

  const MIN_CHARS   = Math.max(0, Number(P["MinCharsForRead"] || 0));
  const CLEAR_ON_NEW= P["ClearHistoryOnNewGame"] !== "false";

  // ---- オプション統合パラメータ
  const SHOW_OPT    = P["ShowInOptions"] !== "false";
  const OPT_DEFAULT = P["OptionDefault"] === "true";
  const OPT_VARID   = Number(P["OptionLabelVarId"] || 0);
  const OPT_FB      = [P["OptionFb0"]||"", P["OptionFb1"]||"", P["OptionFb2"]||"", P["OptionFb3"]||""];

  // ---- 入力（右クリック長押し）初期化
  let IGNORE_RE     = null;
  try {
    const reStr = String(P["IgnoreRegexForRead"] || "").trim();
    IGNORE_RE = reStr ? new RegExp(reStr) : null;
  } catch (e) { IGNORE_RE = null; }

  if (KEY_RCLICK && typeof window !== "undefined" && !window._hsRightMouseSetup) {
    window._hsRightMouseSetup = true;
    window._hsRightPressed = false;
    window.addEventListener("mousedown", e => { if (e.button === 2) window._hsRightPressed = true; }, true);
    window.addEventListener("mouseup",   e => { if (e.button === 2) window._hsRightPressed = false; }, true);
    window.addEventListener("blur", () => { window._hsRightPressed = false; });
  }
  if (!Input.keyMapper[76]) Input.keyMapper[76] = "hs_skip_l";

  // ---- 既読データの器
  const _Game_System_initialize = Game_System.prototype.initialize;
  Game_System.prototype.initialize = function() {
    _Game_System_initialize.call(this);
    this._hsReadText = this._hsReadText || Object.create(null);
  };
  Game_System.prototype.hsIsTextRead  = function(key){ return !!this._hsReadText[key]; };
  Game_System.prototype.hsMarkTextRead= function(key){ if (key) this._hsReadText[key] = true; };

  PluginManager.registerCommand(PN, "ClearHistory", () => {
    if ($gameSystem) $gameSystem._hsReadText = Object.create(null);
  });

  // NewGame時にクリア（任意）
  if (CLEAR_ON_NEW) {
    const _DataManager_setupNewGame = DataManager.setupNewGame;
    DataManager.setupNewGame = function() {
      _DataManager_setupNewGame.call(this);
      if ($gameSystem) $gameSystem._hsReadText = Object.create(null);
      syncSwitchFromConfig(); // ★新規開始時にスイッチへ反映
    };
  }

  // ---- util
  function hashString(s) { let h=2166136261>>>0; for (let i=0;i<s.length;i++){ h^=s.charCodeAt(i); h=Math.imul(h,16777619);} return (h>>>0).toString(16); }
  function skipHeld(){ return (KEY_CTRL && Input.isPressed("control")) || (KEY_L && Input.isPressed("hs_skip_l")) || (KEY_RCLICK && !!window._hsRightPressed); }
  function stripCodes(s){
    return s.replace(/\\[A-Z]\[\d+\]/gi,"").replace(/\\[A-Z]/gi,"").replace(/\\[{}\.|!><]/g,"");
  }
  function coreLen(s){
    const t = stripCodes(s).replace(/[ \t\r\n\u3000]/g,"").replace(/[。、．，,.\-–—…!！?？:：;；「」『』【】\[\]\(\)＜＞<>]/g,"");
    return t.length;
  }
  function qualifies(base){ if (MIN_CHARS>0 && coreLen(base)<MIN_CHARS) return false; if (IGNORE_RE && IGNORE_RE.test(base)) return false; return true; }

  // ---- 言語index（HS_LangSimple前提：ConfigManager.hs_langIndex）
  function langIndex(){
    return Number(ConfigManager && ConfigManager.hs_langIndex != null
      ? ConfigManager.hs_langIndex : 0);
  }
  function pickVarText(varId){
    try {
      if (varId>0 && window.$gameVariables) {
        const v = $gameVariables.value(varId);
        if (typeof v === "string" && v.trim() !== "") return String(v);
      }
    } catch(_){}
    return null;
  }
  function optionLabel(){
    return pickVarText(OPT_VARID) ?? (OPT_FB[langIndex()] || OPT_FB[0] || "Skip Read Text");
  }

  // ---- 文章キー生成（v1.4と同等）
  const _GI_command101 = Game_Interpreter.prototype.command101;
  Game_Interpreter.prototype.command101 = function(params){
    if ($gameMessage) {
      $gameMessage._hsContext = {
        mapId: $gameMap ? $gameMap.mapId() : 0,
        eventId: this._eventId || 0,
        commonId: (typeof this._commonEventId === "number") ? this._commonEventId : 0,
        faceName: params ? String(params[0] || "") : "",
        faceIndex: params ? Number(params[1] || 0) : 0,
        index: this._index || 0,
        indent: this._indent || 0
      };
    }
    return _GI_command101.apply(this, arguments);
  };

  const _WM_startMessage = Window_Message.prototype.startMessage;
  Window_Message.prototype.startMessage = function(){
    const texts = ($gameMessage && $gameMessage._texts) ? $gameMessage._texts.slice() : [];
    let base = texts.join("\n");

    const ctx = $gameMessage ? $gameMessage._hsContext : null;
    if (LANG_VAR > 0) base = `[lang:${$gameVariables.value(LANG_VAR)}]` + base;
    if (INCLUDE_ME) {
      const mid = ctx ? ctx.mapId : ($gameMap ? $gameMap.mapId() : 0);
      const eid = ctx ? ctx.eventId : 0;
      base = `[${mid}:${eid}]` + base;
    }
    if (INCLUDE_CE) base = `[ce:${ctx ? ctx.commonId : 0}]` + base;
    if (INCLUDE_FACE) base = `[face:${ctx ? ctx.faceName : ""}:${ctx ? ctx.faceIndex : 0}]` + base;
    if (INCLUDE_IDX) base = `[idx:${ctx ? ctx.index : 0}:${ctx ? ctx.indent : 0}]` + base;

    this._hsBaseForRead = base;
    this._hsCurrentHash = hashString(base);
    this._hsQualifies   = qualifies(base);
    this._hsIsRead      = this._hsQualifies && $gameSystem.hsIsTextRead(this._hsCurrentHash);

    if (this._hsIsRead && READ_COLOR >= 0 && texts.length > 0) {
      for (let i=0;i<$gameMessage._texts.length;i++){
        $gameMessage._texts[i] = `\\C[${READ_COLOR}]` + $gameMessage._texts[i] + `\\C[0]`;
      }
    }
    _WM_startMessage.call(this);
  };

  const _WM_terminateMessage = Window_Message.prototype.terminateMessage;
  Window_Message.prototype.terminateMessage = function(){
    if (this._hsCurrentHash && this._hsQualifies) $gameSystem.hsMarkTextRead(this._hsCurrentHash);
    _WM_terminateMessage.call(this);
  };

    // ---- 追加(v1.5.2): オプション表示中は既読スキップを停止（Scene_Options / OptionsOverlay 両対応）
  function hsIsOptionsOpen(){
    const scene = (typeof SceneManager !== "undefined") ? SceneManager._scene : null;
    if (!scene) return false;

    // 通常のオプションシーン
    if (typeof Scene_Options !== "undefined" && scene instanceof Scene_Options) return true;

    // HS_OptionsOverlay.js の重ね表示（Sceneに _hsOptionsWin を持つ）
    if (scene._hsOptionsWin) return true;

    // 他プラグインでの重ね表示に備え、Window_Options が見えていれば停止
    try{
      const layer = scene._windowLayer;
      const children = layer && layer.children ? layer.children : [];
      for (let i=0;i<children.length;i++){
        const w = children[i];
        if (!w) continue;
        if (typeof Window_Options !== "undefined" && w instanceof Window_Options){
          if (w.visible && w.openness > 0) return true;
        }
      }
    }catch(_){}

    // HS_OptionsOverlay_InputLock.js が提供する便利フラグがあればそれも参照
    try{
      if (window.HS?.isOptionsOverlayOpen?.()) return true;
    }catch(_){}

    return false;
  }

const _WM_update = Window_Message.prototype.update;
  Window_Message.prototype.update = function(){
    _WM_update.call(this);
    if (!this.isOpen()) return;
    if (!$gameSwitches.value(SWITCH_ID)) return;
    if (!this._hsIsRead) return;

    if (this._choiceWindow && this._choiceWindow.active) return;
    if (this._numberInputWindow && this._numberInputWindow.active) return;
    if (this._itemChoiceWindow && this._itemChoiceWindow.active) return;

    if (hsIsOptionsOpen()) { this._showFast = false; this._lineShowFast = false; return; }

    const wantSkip = AUTO_ADV || skipHeld();
    if (!wantSkip) return;

    this._showFast = true;
    this._lineShowFast = true;

    if (this.pause) { this.pause = false; this.terminateMessage(); }
  };

  // =========================================================
  //  オプション統合：Config <-> スイッチ 同期 & 多言語ラベル
  // =========================================================

  // 1) ConfigManager に項目を追加（グローバル設定）
  if (typeof ConfigManager.hsReadSkipEnabled === "undefined") {
    ConfigManager.hsReadSkipEnabled = OPT_DEFAULT;
  }

  const _CM_makeData = ConfigManager.makeData;
  ConfigManager.makeData = function(){
    const config = _CM_makeData ? _CM_makeData.call(this) : {};
    config.hsReadSkipEnabled = this.hsReadSkipEnabled;
    return config;
  };

  const _CM_applyData = ConfigManager.applyData;
  ConfigManager.applyData = function(config){
    if (_CM_applyData) _CM_applyData.call(this, config);
    this.hsReadSkipEnabled = this.readFlag(config, "hsReadSkipEnabled");
    if (this.hsReadSkipEnabled === undefined) this.hsReadSkipEnabled = OPT_DEFAULT;
  };

  // 2) ゲーム進行中のスイッチへ反映
  function syncSwitchFromConfig(){
    try{
      if ($gameSwitches && SWITCH_ID>0){
        $gameSwitches.setValue(SWITCH_ID, !!ConfigManager.hsReadSkipEnabled);
      }
    }catch(_){}
  }

  // 新規開始＆ロード後に同期
  const _Scene_Load_onLoadSuccess = Scene_Load.prototype.onLoadSuccess;
  Scene_Load.prototype.onLoadSuccess = function(){
    _Scene_Load_onLoadSuccess.call(this);
    syncSwitchFromConfig();
  };

  const _Scene_Map_start = Scene_Map.prototype.start;
  Scene_Map.prototype.start = function(){
    _Scene_Map_start.call(this);
    syncSwitchFromConfig();
  };

  // 3) オプション画面へ項目追加 & ラベル多言語化
  if (SHOW_OPT) {
    const _WO_addGeneral = Window_Options.prototype.addGeneralOptions;
    Window_Options.prototype.addGeneralOptions = function(){
      _WO_addGeneral.apply(this, arguments);
      // シンボル名＝ConfigManagerのプロパティ名に合わせると、標準ON/OFFトグルが動作します
      this.addCommand(optionLabel(), "hsReadSkipEnabled");
    };

    // 言語切替・変数変更後のラベル更新
    function relabel(win){
      if (!win || !win._list) return;
      for (let i=0;i<win._list.length;i++){
        const it = win._list[i];
        if (it && it.symbol === "hsReadSkipEnabled") it.name = optionLabel();
      }
    }
    const _SO_start = Scene_Options.prototype.start;
    Scene_Options.prototype.start = function(){
      _SO_start.call(this);
      if (this._optionsWindow){
        try{ relabel(this._optionsWindow); this._optionsWindow.refresh(); }catch(_){}
        setTimeout(()=>{ try{ relabel(this._optionsWindow); this._optionsWindow.refresh(); }catch(_){} }, 0);
      }
    };
    const _WO_refresh = Window_Options.prototype.refresh;
    Window_Options.prototype.refresh = function(){
      try{ relabel(this); }catch(_){}
      _WO_refresh.call(this);
    };

    // 4) オプションで値変更→即スイッチへ反映
    const _WO_changeValue = Window_Options.prototype.changeValue;
    Window_Options.prototype.changeValue = function(symbol, value){
      _WO_changeValue.call(this, symbol, value);
      if (symbol === "hsReadSkipEnabled") {
        syncSwitchFromConfig();
        try{ relabel(this); this.refresh(); }catch(_){}
      }
    };
  }

})();